//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Threading;

namespace ProfilingSamples
{
	public class GCGenerationMain 
	{
		public class BaseObj 
		{
			private string name;
			public BaseObj(string name)
			{
				this.name = name;
			}
		}
		public class TestObj : BaseObj 
		{
			public TestObj(String s) : base(s) 
			{
			}
			public int Generation 
			{
				get
				{
					return GC.GetGeneration(this);
				}
			}
		}
		void TestThread()
		{
			try
			{
				// Sprawdmy, ile generacji moe obsuy zarzdzana sterta (wiemy, e s to 2 generacje)
				Console.WriteLine("Maksymalna liczba generacji GC: {0}", GC.MaxGeneration);
				TestObj [] toa = new TestObj[10];
				while(true)
				{ 
					for(int i = 0; i < toa.Length; i++)
						toa[i] = new TestObj("TestObj" + i.ToString());

					// Wykonanie GC zmienia generacj obiektu
					GC.Collect();

					GC.Collect();

					GC.Collect();

					// Zniszczenie silnego odwoania do tego obiektu
					for(int i = 0; i < toa.Length; i++)
						toa[i] = null;

					GC.Collect(0);
					GC.WaitForPendingFinalizers();

					GC.Collect(1);
					GC.WaitForPendingFinalizers();

					GC.Collect(2);
					GC.WaitForPendingFinalizers();

					Thread.Sleep(500);
				}
			}
			catch(Exception e)
			{
				Console.WriteLine("TestThread przerywa prac: {0}", e.Message);
			}
		}
		static void Main(string [] args)
		{
			GCGenerationMain m = new GCGenerationMain();
			Thread testThread = new Thread(new ThreadStart(m.TestThread));
			testThread.Start();
			string input = Console.ReadLine();
			testThread.Abort();
			testThread.Join();
		}
	}
}